@echo off
ECHO ----
ECHO -----------
ECHO -------------------------------------------------------------
ECHO Instalacja aktualizacji systemu Sage Symfonia ERP (modul HMF)
ECHO -------------------------------------------------------------
ECHO -----------
ECHO ----
rem Skrypt instaluje dll z aktualnego katalogu do katalogu Sage\Symfonia ERP\23.0
rem Katalog w ktrym jest skrypt
set SCRIPTDIR=%~dp0
rem Katalog w jakim jestesmy w konsoli w trakcie uruchamiania skryptu
set CURRENTDIR=%CD%

rem Opis poprawki
rem TYPE %SCRIPTDIR%ReadMe.txt

rem Wykrywanie wersji Windows
rem for /f "tokens=4-7 delims=[.] " %%i in ('ver') do (if %%i==Version (set WIN_VER=%%j.%%k) else (set WIN_VER=%%i.%%j))

REM Wykrywanie 64b vs 32b
rem reg Query "HKLM\Hardware\Description\System\CentralProcessor\0" | find /i "x86" > NUL && set OS=32BIT || set OS=64BIT
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (set OS=32BIT) else (set OS=64BIT)

echo Wersja systemu Windows: %OS%

IF "%OS%"=="64BIT" (
ECHO -------------------------------------------------------------
echo HMF 2023
ECHO -------------------------------------------------------------
call :RegImpl "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Sage\Symfonia ERP\23.0\HMF" InstallDir ) 

IF "%OS%"=="32BIT" (
ECHO -------------------------------------------------------------
echo HMF 2023
ECHO -------------------------------------------------------------
call :RegImpl "HKEY_LOCAL_MACHINE\SOFTWARE\Sage\Symfonia ERP\23.0\HMF" InstallDir )


ECHO.
ECHO --------------------------------------------------------
ECHO --- Zakonczono aktualizacje ----------------------------
ECHO --------------------------------------------------------

echo.
echo Nacisnij dowolny klawisz . . .
pause

goto end


:RegImpl
REM @echo OFF

setlocal ENABLEEXTENSIONS

set KEY_NAME="%~1"
set VALUE_NAME=%~2
set VERSION="%~3"
set FOUND=0

FOR /F "usebackq skip=2 tokens=1,2*" %%A IN (`REG QUERY %KEY_NAME% /v %VALUE_NAME% 2^>nul`) DO (
    if %%A==%VALUE_NAME% (
       Rem tutaj wiemy e zainstalowano w tej wesji
       Rem VERSION zawiera wersj (katalog) do podmiany, 
       Rem miejsce instalacji jest w %%C
       
        rem @echo Name = %%A
        rem @echo Type = %%B
        rem @echo InstallFolder = %%C 
	set FOUND=1
ECHO -------------------------------------------------------------
echo Znaleziono HMF w katalogu 
echo "%%C"	
ECHO -------------------------------------------------------------
	set MyPath=%%C
	   call :Install Install %VERSION% InstallFolder %VERSION%
    )
)
if %FOUND%==0 (
   echo Nie znaleziono HMF w katalogu "%%C"
)
echo.   
echo Nacisnij dowolny klawisz . . .
pause
exit /b
echo ##########################################################
REM -----------------------------------------------------------


:Install
echo off
REM folder z ktrego instalujemy
set "SourceFolder=%~1"
set "DestinationFolder=%~2"
set "ExeVersion=%~3"

REM kopiowanie dll'ek pod exe'ka aplikacji
ECHO ----
ECHO -----------
ECHO -------------------------------------------------------------
ECHO Kopiowanie plikow do katalogu aplikacji:
ECHO -------------------------------------------------------------

 xcopy "%SCRIPTDIR%\Dodatki\Copy" "%MyPath%" /F /Y /R
 xcopy "%SCRIPTDIR%\Dodatki\Resources" "%MyPath%\Resources"  /F /Y /R
 xcopy "%SCRIPTDIR%\Dodatki\Resources\Metadata" "%MyPath%\Resources\Metadata"  /F /Y /R
 xcopy "%SCRIPTDIR%\Dodatki\Templates" "%MyPath%\Szablon"  /F /Y /R

IF errorlevel 1 GOTO error

goto ok


:error
ECHO ----
ECHO -----------
ECHO --------------------------------------------------------
ECHO UWAGA!
ECHO Aktualizacja wersji HMF '%ExeVersion%' NIE zostala zainstalowana.
ECHO Prosze uruchomic skrypt z prawami administratora.
ECHO --------------------------------------------------------
ECHO -----------
ECHO ----
EXIT /b

:ok
ECHO ----
ECHO -----------
ECHO --------------------------------------------------------
ECHO Aktualizacja dla wersji HMF '%ExeVersion%'  zostala zainstalowana poprawnie
ECHO --------------------------------------------------------
ECHO -----------
ECHO ----
EXIT /b

:end
